<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
    <div class="wrapper">
        <?php echo $page_header; ?>
        <?php echo $column_left; ?>
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1><?php echo $lang['heading_title']; ?></h1>
                <div class="row">
                    <div class="col-sm-6">
                        <ol class="breadcrumb">
                            <?php foreach($breadcrumbs as $breadcrumb): ?>
                            <li>
                                <a href="<?php echo $breadcrumb['href']; ?>">
                                    <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                    <?php echo $breadcrumb['text']; ?>
                                </a>
                            </li>
                            <?php endforeach; ?>
                        </ol>
                    </div>

                    <div class="col-sm-6">
                        <div class="pull-right">
                            <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                <i class="fa fa-undo"></i>
                                &nbsp;<?php echo $lang['cancel']; ?>
                            </a>
                            <?php if($approved_status == 'Pending'): ?>
                            <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                <i class="fa fa-floppy-o"></i>
                                &nbsp;Save as Draft
                            </a>
                            <a class="btn btn-primary" href="javascript:void(0);" onclick="saveSubmit();">
                                <i class="fa fa-floppy-o"></i>
                                &nbsp;Save & Submit
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-header">
                                <?php if ($error_warning) { ?>
                                <div class="alert alert-danger alert-dismissable">
                                    <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                    <?php echo $error_warning; ?>
                                </div>
                                <?php } ?>
                                <?php  if ($success) { ?>
                                <div class="alert alert-success alert-dismissable">
                                    <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                    <?php echo $success; ?>
                                </div>
                                <?php  } ?>
                            </div><!-- /.box-header -->
                            <div class="box-body">
                                <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                    <input type="hidden" id="company_id" name="company_id" value="<?php echo $company_id; ?>" />
                                    <input type="hidden" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" />
                                    <div class="row">
                                        <div class="col-sm-8">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['receipt_no']; ?></label>
                                                        <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['date']; ?></label>
                                                        <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['document']; ?></label>
                                                        <?php if($href_document_file != ''): ?>
                                                        <a target="_blank" class="pull-right" href="<?php echo $href_document_file; ?>" title="Document"><?php echo $file_name; ?></a>
                                                        <?php endif; ?>
                                                        <input type="file" class="form-control" id="document" name="document" value="" accept="text/plain"  />
                                                        <input type="hidden" class="form-control" id="file_name" name="file_name" value="<?php echo $file_name; ?>" />
                                                        <input type="hidden" class="form-control" id="file_directory" name="file_directory" value="<?php echo $file_directory; ?>" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                                        <select id="employee_registration_id" name="employee_registration_id" class="form-control">
                                                            <option data-registration_code="" data-company_id="">&nbsp;</option>
                                                            <?php foreach($employees as $employee): ?>
                                                            <option data-employee_code="<?php echo $employee['employee_code']?>" data-employee_id="<?php echo $employee['employee_id']?>" data-registration_code="<?php echo $employee['registration_code']?>" data-company_id="<?php echo $employee['company_id']?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?> value="<?php echo $employee['employee_registration_id']; ?>"><?php echo $employee['company_name'].' - '.$employee['department_name']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                        <label class="error" for="employee_registration_id" style="display: none;">&nbsp;</label>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['allowance_type']; ?></label>
                                                        <?php if($isEdit==1): ?>
                                                        <input type="text" class="form-control" id="special_allowance_type" value="<?php echo $special_allowance_type; ?>" readonly/>
                                                        <input type="hidden" class="form-control" id="special_allowance_type_id" name="special_allowance_type_id" value="<?php echo $special_allowance_type_id; ?>" readonly/>
                                                        <?php else: ?>
                                                        <select id="special_allowance_type_id" name="special_allowance_type_id" class="form-control">
                                                            <option>&nbsp;</option>
                                                        </select>
                                                        <label class="error" for="special_allowance_type_id" style="display: none;">&nbsp;</label>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['total_amount']; ?></label>
                                                        <input type="text" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" class="form-control" readonly/>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="alert alert-danger alert-dismissable">
                                                        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                                        Please make sure your family data is updated. To verify <a target="_blank" href="<?php echo $href_employee_profile; ?>">click here</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row" id="divPeriod" <?php echo ($special_allowance_type_id==2?'':'style="display:none;"');?>>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['medical_from']; ?></label>
                                                        <input type="text" id="medical_from" name="medical_from" value="<?php echo $medical_from; ?>" class="form-control dtpDate"/>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['medical_to']; ?></label>
                                                        <input type="text" id="medical_to" name="medical_to" value="<?php echo $medical_to; ?>" class="form-control dtpDate"/>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="table-responsive">
                                                        <table id="tblSpecialAllowance" class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th style="width: 15px;"><a class="btnAddAllowance btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></th>
                                                                    <th class="text-center"><?php echo $lang['allowance_for']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['allowance_category']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['amount']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['remarks']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['receipt_date']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['receipt_no']; ?></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php $grid_row_allowance=0;$grid_row_allowance_desc=count($allowance_details); ?>
                                                                <?php foreach($allowance_details as $detail): ?>
                                                                <?php $grid_row_allowance_desc--; ?>
                                                                <tr id="grid_row_id_<?php echo $grid_row_allowance_desc; ?>" data-row_id="<?php echo $grid_row_allowance_desc; ?>">
                                                                    <td style="width: 15px;">
                                                                        <a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a>
                                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_special_allowance_detail_id" name="details[<?php echo $grid_row_allowance_desc; ?>][special_allowance_detail_id]" value="<?php echo $detail['special_allowance_detail_id']; ?>" />
                                                                    </td>
                                                                    <td>
                                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_allowance_for" name="details[<?php echo $grid_row_allowance_desc; ?>][allowance_for]" value="<?php echo $detail['allowance_for']; ?>" />
                                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_school_id" name="details[<?php echo $grid_row_allowance_desc; ?>][school_id]" value="<?php echo $detail['school_id']; ?>" />
                                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_class_id" name="details[<?php echo $grid_row_allowance_desc; ?>][class_id]" value="<?php echo $detail['class_id']; ?>" />
                                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_period_start_date" name="details[<?php echo $grid_row_allowance_desc; ?>][period_start_date]" value="<?php echo $detail['period_start_date']; ?>" />
                                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_period_end_date" name="details[<?php echo $grid_row_allowance_desc; ?>][period_end_date]" value="<?php echo $detail['period_end_date']; ?>" />
                                                                        <select required onchange="updateRelation('<?php echo $grid_row_allowance_desc; ?>');" class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_employee_family_id" name="details[<?php echo $grid_row_allowance_desc; ?>][employee_family_id]" >
                                                                            <option value="">&nbsp;</option>
                                                                            <?php foreach($families as $family): ?>
                                                                            <option <?php echo ($family['employee_family_id']==$detail['employee_family_id']?'selected="true"':'');?> data-relation="<?php echo $family['relation']; ?>" data-school_id="<?php echo $family['school_id']; ?>" data-class_id="<?php echo $family['class_id']; ?>" data-period_start_date="<?php echo $family['period_start_date']; ?>" data-period_end_date="<?php echo $family['period_end_date']; ?>" data-school="<?php echo $family['school_name'].' - '.$family['class_name']; ?>" data-employee_family_id="<?php echo $detail['employee_family_id']; ?>" value="<?php echo $family['employee_family_id']; ?>"><?php echo $family['full_name']; ?></option>
                                                                            <?php endforeach; ?>
                                                                        </select>
                                                                        <label for="detail_<?php echo $grid_row_allowance_desc; ?>_employee_family_id" class="error">&nbsp;</label>
                                                                    </td>
                                                                    <td>
                                                                        <select required class="form-control" id="detail_<?php echo $grid_row_allowance_desc; ?>_special_allowance_category_id" name="details[<?php echo $grid_row_allowance_desc; ?>][special_allowance_category_id]" >
                                                                            <option value="">&nbsp;</option>
                                                                            <?php foreach($categories as $category): ?>
                                                                            <option value="<?php echo $category['special_allowance_category_id']; ?>" <?php echo ($detail['special_allowance_category_id']==$category['special_allowance_category_id']?'selected=true':'');?>><?php echo $category['special_allowance_category']; ?></option>
                                                                            <?php endforeach; ?>
                                                                        </select>
                                                                        <label for="detail_<?php echo $grid_row_allowance_desc; ?>_special_allowance_category_id" class="error">&nbsp;</label>
                                                                    </td>
                                                                    <td><input required onchange="calculateTotal();" type="text" class="form-control fPDecimal text-right" id="detail_<?php echo $grid_row_allowance_desc; ?>_amount" name="details[<?php echo $grid_row_allowance_desc; ?>][amount]" value="<?php echo $detail['amount']; ?>" /></td>
                                                                    <td><input type="text" class="form-control" maxlength="60" id="detail_<?php echo $grid_row_allowance_desc; ?>_remarks" name="details[<?php echo $grid_row_allowance_desc; ?>][remarks]" value="<?php echo $detail['remarks']; ?> " /></td>
                                                                    <td><input type="text" class="form-control dtpDate" id="detail_<?php echo $grid_row_allowance_desc; ?>_receipt_date" name="details[<?php echo $grid_row_allowance_desc; ?>][receipt_date]" value="<?php echo $detail['receipt_date']; ?>" /></td>
                                                                    <td>
                                                                        <input type="text" class="form-control" maxlength="21" id="detail_<?php echo $grid_row_allowance_desc; ?>_receipt_no" name="details[<?php echo $grid_row_allowance_desc; ?>][receipt_no]" value="<?php echo $detail['receipt_no']; ?>" />
                                                                        <input type="hidden" id="detail_<?php echo $grid_row_allowance_desc; ?>_policy_on" name="details[<?php echo $grid_row_allowance_desc; ?>][policy_on]" value="<?php echo $detail['policy_on']; ?>" />
                                                                        <input type="hidden" id="detail_<?php echo $grid_row_allowance_desc; ?>_policy_value" name="details[<?php echo $grid_row_allowance_desc; ?>][policy_value]" value="<?php echo $detail['policy_value']; ?>" />
                                                                        <input type="hidden" id="detail_<?php echo $grid_row_allowance_desc; ?>_policy_amount" name="details[<?php echo $grid_row_allowance_desc; ?>][policy_amount]" value="<?php echo $detail['policy_amount']; ?>" />
                                                                    </td>
                                                                </tr>
                                                                <?php $grid_row_allowance++; ?>
                                                                <?php endforeach; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="panel panel-info">
                                                <div class="panel-heading">
                                                    <label><?php echo $lang['allowance_policy']; ?></label>
                                                </div>
                                                <div class="panel-body">
                                                    <div id="divPolicy" class="table-responsive">
                                                        <table class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Allowance For</th>
                                                                    <th>Allowance Category</th>
                                                                    <th>Allowance On</th>
                                                                    <th>Allowance Value</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach($policies as $policy): ?>
                                                                <tr>
                                                                    <td><?php echo $policy['relation']; ?></td>
                                                                    <td><?php echo $policy['allowance_category']; ?></td>
                                                                    <td><?php echo $policy['allowance_on']; ?></td>
                                                                    <td><?php echo $policy['allowance_value']; ?></td>
                                                                </tr>
                                                                <?php endforeach; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel panel-info">
                                                <div class="panel-heading">
                                                    <label>Previous Approved.</label>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                        <table id="tblApproved" class="table table-stripped">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-center"><?php echo $lang['date']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['voucher_no']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['total_amount']; ?></th>
                                                                    <th class="text-center"><?php echo $lang['approved_amount']; ?></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach($approved_allowances as $allowance): ?>
                                                                <tr>
                                                                    <td class="text-center"><?php echo $allowance['document_date']; ?></td>
                                                                    <td class="text-center"><?php echo $allowance['document_identity']; ?></td>
                                                                    <td class="text-center"><?php echo $allowance['total_amount']; ?></td>
                                                                    <td class="text-center"><?php echo $allowance['approved_amount']; ?></td>
                                                                </tr>
                                                                <?php endforeach; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <?php if($approved_status == 'Pending'): ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;Save as Draft
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="saveSubmit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;Save & Submit
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
        <script type="text/javascript" src="../employee/view/js/employee/employee_allowance_request.js?v=1.0"></script>
        <script>
            function saveSubmit() {
                var $URLSave = '<?php echo $action_save; ?>&submit=1';
                $('#form').attr('action', $URLSave).submit();
            }

            jQuery('#form').validate(<?php echo $strValidation; ?>);

            var $policies = <?php echo json_encode($arrPolicies); ?>;
            var $families = <?php echo json_encode($families); ?>;
            var $special_allowance_types = <?php echo json_encode($special_allowance_types); ?>;
            var $grid_row_allowance = <?php echo $grid_row_allowance; ?>;
            var $URLGetAllowedAllowanceType = '<?php echo $href_get_allowed_allowance_type; ?>';
            var $URLGetPolicy = '<?php echo $href_get_policy; ?>';
            var $URLGetEmployeeAllowance = '<?php echo $href_get_emp_allowance; ?>';
            var $URLGetAllowanceCategory = '<?php echo $href_get_allowance_category; ?>';
            var $allowance_allowed = <?php echo $allowance_allowed; ?>;
            var $categories = <?php echo json_encode($categories); ?>;
        </script>

        <!-- Modal -->
        <div class="modal fade" id="myModal" role="dialog">
            <div class="modal-dialog">
              <!-- Modal content-->
              <div class="modal-content">
                <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">Family Member</h4>
              </div>
              <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <th>Name</th>
                            <th>Relation</th>
                            <th>Period Start Date</th>
                            <th>Period End Date</th>
                            <th>CNIC</th>
                            <th>School</th>
                            <th>Class</th>
                            <th>Qualification</th>
                        </thead>
                        <tbody>
                            <?php
                            foreach($families as $family)
                            { ?>
                                <tr>
                                    <td><?php echo $family['full_name']; ?></td>
                                    <td><?php echo $family['relation']; ?></td>
                                    <td><?php echo $family['period_start_date']; ?></td>
                                    <td><?php echo $family['period_end_date']; ?></td>
                                    <td><?php echo $family['cnic_no']; ?></td>
                                    <td><?php echo $family['school_name']; ?></td>
                                    <td><?php echo $family['class_name']; ?></td>
                                    <td><?php echo $family['qualification']; ?></td>
                                </tr>
                            <?php }
                            ?>
                            
                        </tbody>
                    </table>    
                </div>
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                  <a href="<?php echo $href_employee_profile; ?>" class="btn btn-info">Update Profile Data</a>
              </div>
          </div>
      </div>
  </div>

  <?php echo $page_footer; ?>
  <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>